// testMain.cpp
// backprop rat brain for spatial symmetry testing
// CGP; 6/22/00

const int MAX_NUMBER_TRIALS = 200;
const int WINDOW_SIZE = 10;

// rat must get at least 87.5% correct
const double PERF_CRITERIA = 0.875;

#include "BrainUtils.h"
#include "WorldModel.h"
#include "brain.h"
#include "PerfStats.h"

int main()
{
  WorldModel wm;
  RatBrain brain (&wm);
  bool trialCorrect;
  PerfStats perf(WINDOW_SIZE);
  
  // Keep track of a running mean of correct responses to the
  // last 64 trials.
  
  for (;;) {
    wm.NextTrial(); // set up maze for next trial
    trialCorrect = brain.TrainStep(); // put rat on maze
    
    // add performance on that trial to the performance statistics
    perf.Add(trialCorrect);
    
    // output performance statistics
    cout << "t#" << wm.GetCurrTrialNumber() << " " <<
      100.0 * perf.GetNumberCorrect()/perf.GetCurrWindow() << "% " <<
      "(" << perf.GetNumberCorrect() << "/" << perf.GetCurrWindow() << ")\n";
      
    // stop if we have exceeded max trials
    if (wm.GetCurrTrialNumber() > MAX_NUMBER_TRIALS) {
    
      cout << "Exceeded max number trials (" << MAX_NUMBER_TRIALS << " trials)\n";
      break;
    }
    
    // stop if we have met criteria
    if ((perf.GetCurrWindow() >= WINDOW_SIZE) &&
      (perf.GetNumberCorrect() >= PERF_CRITERIA * WINDOW_SIZE)) {
      
      cout << "Met criteria of " <<
        100.0 * perf.GetNumberCorrect()/perf.GetCurrWindow() << "% ";
      cout << "in window of " << perf.GetCurrWindow() << " trials.\n";
      break;
    }
  } 
  
  cout << "Ran rat for " << wm.GetCurrTrialNumber() << " trials.\n";
}
